/* tslint:disable */
/* eslint-disable */

export type TKeyPair = {
    public: string;
    secret: string;
};

export type TParamsOfDeployMultifactor = {
    wallet_name: string;
    zkid: string;
    password: string;
    proof: string;
    epk: string;
    esk: string;
    jwk_modulus: string;
    jwk_modulus_expire_at: number;
    index_mod_4: number;
    iss_base_64: string;
    header_base_64: string;
    epk_expire_at: number;
    kid: string;
    sub: string;
};

export type TParamsOfDeployMiner = {
    multifactor_address: string
    signer_keys: TKeyPair,
};

export type TParamsOfSetMiningKeys = {
    multifactor_address: string
    signer_keys: TKeyPair,
    mining_pubkey: string,
};

export type TParamsOfSign = {
    unsigned: string;
    keys: TKeyPair;
}

export type TParamsOfAddZKPFactor = {
    wallet_name: string;
    proof: string;
    epk: string;
    esk: string;
    header_base_64: string;
    epk_expire_at: number;
    jwk_expires_at: number;
    kid: string;
    sub: string;
    password: string
    zkid: string
}

export type TParamsOfGetMultifactorBalances = {
    multifactor_address: string;
};

export type TParamsOfGetTokensBalances = {
    multifactor_address: string;
    token_roots: string[];
};

export type TParamsOfGetMiningHistory = {
    multifactor_address: string
};

export type TParamsOfGetMinerAddress = {
    multifactor_address: string
};

export type TResultOfMinerOwnerPublic = Record<string, string>;



export class Miner {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  get_reward(): Promise<void>;
  static new(endpoints: string[], app_id: string, address: string, public_key: string, secret_key: string): Promise<Miner>;
  remove_seed(seed: string): void;
  stop(): void;
  start(duration_ms: number, callback: Function): void;
  add_tap(x: number, y: number): void;
  can_start(): boolean;
}

export class ResultOfAddZKPFactor {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly signing_keys: ResultOfGetKeys;
  readonly password_hash: string;
  readonly name: string;
  readonly pubkey: string;
  readonly address: string;
}

export class ResultOfCheckNameAvailability {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly is_available: boolean;
  readonly multifactor_address: string | undefined;
}

export class ResultOfDeployMultifactor {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly signing_keys: ResultOfGetKeys;
  readonly password_hash: string;
  readonly name: string;
  readonly phrase: string;
  readonly pubkey: string;
  readonly address: string;
}

export class ResultOfEncrypt {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly encrypted: string;
}

export class ResultOfGetKeys {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly public: string;
  readonly secret: string;
}

export class ResultOfGetMinerDetails {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly owner_public: TResultOfMinerOwnerPublic;
  readonly owner_address: string;
  readonly address: string;
}

export class ResultOfGetMultifactorDetails {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly factors_len: string;
  readonly index_mod_4: string;
  readonly iss_base_64: string;
  readonly owner_pubkey: string;
  readonly jwk_update_key: string;
  readonly jwk_modulus_data: any;
  readonly max_cleanup_txns: string;
  readonly pub_recovery_key: string;
  readonly use_security_card: boolean;
  readonly m_transactions_len: string;
  readonly force_remove_oldest: boolean;
  readonly jwk_modulus_data_len: string;
  readonly m_security_cards_len: string;
  readonly white_list_of_address: any;
  readonly factors_ordered_by_timestamp: any;
  readonly candidate_new_owner_pubkey_and_expiration: any;
  readonly name: string;
  readonly root: string;
  readonly zkid: string;
  readonly address: string;
  readonly min_value: string;
  readonly wasm_hash: string;
}

export class ResultOfGetNativeBalances {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly ecc: any;
  readonly popitgame: any;
}

export class ResultOfGetTokensBalances {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly tokens: any;
}

export class ResultOfGetTxHistory {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly data: TxData[];
}

export class ResultOfSign {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  readonly signed: string;
  readonly signature: string;
}

export class ResultOfValidateWalletName {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  static new(is_valid: boolean, error_code?: WalletNameErrorCode | null): ResultOfValidateWalletName;
  readonly error_code: WalletNameErrorCode | undefined;
  readonly is_valid: boolean;
}

export class TxData {
  private constructor();
  free(): void;
  [Symbol.dispose](): void;
  value(): string;
  readonly created_at: string;
  readonly id: string;
}

export class Wallet {
  free(): void;
  [Symbol.dispose](): void;
  /**
   * deploy miner
   * skips deploy if miner is already deployed
   */
  deploy_miner(params_js: TParamsOfDeployMiner): Promise<void>;
  /**
   * deploy multifactor
   */
  deploy_wallet(params_js: TParamsOfDeployMultifactor): Promise<ResultOfDeployMultifactor>;
  add_zkp_factor(params_js: TParamsOfAddZKPFactor): Promise<ResultOfAddZKPFactor>;
  gen_mining_keys(): Promise<ResultOfGetKeys>;
  /**
   * set mining keys for the app_id specified in sdk init
   */
  set_mining_keys(params_js: TParamsOfSetMiningKeys): Promise<void>;
  verify_mnemonic(pharse: string): Promise<boolean>;
  get_miner_address(params_js: TParamsOfGetMinerAddress): Promise<string>;
  get_mining_history(params_js: TParamsOfGetMiningHistory): Promise<ResultOfGetTxHistory>;
  get_tokens_balances(params_js: TParamsOfGetTokensBalances): Promise<ResultOfGetTokensBalances>;
  get_keys_from_mnemonic(pharse: string): Promise<ResultOfGetKeys>;
  check_name_availability(wallet_name: string): Promise<ResultOfCheckNameAvailability>;
  get_multifactor_balances(params_js: TParamsOfGetMultifactorBalances): Promise<ResultOfGetNativeBalances>;
  get_multifactor_data_by_name(wallet_name: string): Promise<ResultOfGetMultifactorDetails | undefined>;
  get_miner_details_by_multifactor_address(multifactor_address: string): Promise<ResultOfGetMinerDetails>;
  sign(params_js: TParamsOfSign): Promise<ResultOfSign>;
  validate_name(wallet_name: string): ResultOfValidateWalletName;
  constructor(endpoints: string[], api_url: string, app_id: string);
  hash(data: string): string;
  decrypt(encrypted: string, password: string): string;
  encrypt(plaintext: string, password: string): ResultOfEncrypt;
}

export enum WalletNameErrorCode {
  InvalidCharacters = 1,
  ConsecutiveHyphens = 2,
  ConsecutiveUnderscores = 3,
  StartsWithSymbol = 4,
  TooLong = 5,
  TooShort = 6,
}

export type InitInput = RequestInfo | URL | Response | BufferSource | WebAssembly.Module;

export interface InitOutput {
  readonly memory: WebAssembly.Memory;
  readonly __wbg_resultofaddzkpfactor_free: (a: number, b: number) => void;
  readonly resultofaddzkpfactor_address: (a: number) => [number, number];
  readonly resultofaddzkpfactor_name: (a: number) => [number, number];
  readonly resultofaddzkpfactor_password_hash: (a: number) => [number, number];
  readonly resultofaddzkpfactor_pubkey: (a: number) => [number, number];
  readonly resultofaddzkpfactor_signing_keys: (a: number) => number;
  readonly __wbg_resultofencrypt_free: (a: number, b: number) => void;
  readonly __wbg_resultofgetkeys_free: (a: number, b: number) => void;
  readonly __wbg_resultofsign_free: (a: number, b: number) => void;
  readonly resultofencrypt_encrypted: (a: number) => [number, number];
  readonly resultofgetkeys_public: (a: number) => [number, number];
  readonly resultofgetkeys_secret: (a: number) => [number, number];
  readonly resultofsign_signature: (a: number) => [number, number];
  readonly resultofsign_signed: (a: number) => [number, number];
  readonly __wbg_resultofchecknameavailability_free: (a: number, b: number) => void;
  readonly __wbg_resultofgetmultifactordetails_free: (a: number, b: number) => void;
  readonly __wbg_resultofvalidatewalletname_free: (a: number, b: number) => void;
  readonly resultofchecknameavailability_is_available: (a: number) => number;
  readonly resultofchecknameavailability_multifactor_address: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_address: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_candidate_new_owner_pubkey_and_expiration: (a: number) => any;
  readonly resultofgetmultifactordetails_factors_len: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_factors_ordered_by_timestamp: (a: number) => any;
  readonly resultofgetmultifactordetails_force_remove_oldest: (a: number) => number;
  readonly resultofgetmultifactordetails_index_mod_4: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_iss_base_64: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_jwk_modulus_data: (a: number) => any;
  readonly resultofgetmultifactordetails_jwk_modulus_data_len: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_jwk_update_key: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_m_security_cards_len: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_m_transactions_len: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_max_cleanup_txns: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_min_value: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_name: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_owner_pubkey: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_pub_recovery_key: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_root: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_use_security_card: (a: number) => number;
  readonly resultofgetmultifactordetails_wasm_hash: (a: number) => [number, number];
  readonly resultofgetmultifactordetails_white_list_of_address: (a: number) => any;
  readonly resultofgetmultifactordetails_zkid: (a: number) => [number, number];
  readonly resultofvalidatewalletname_error_code: (a: number) => number;
  readonly resultofvalidatewalletname_is_valid: (a: number) => number;
  readonly resultofvalidatewalletname_new: (a: number, b: number) => number;
  readonly __wbg_resultofgetnativebalances_free: (a: number, b: number) => void;
  readonly __wbg_resultofgettokensbalances_free: (a: number, b: number) => void;
  readonly resultofgetnativebalances_ecc: (a: number) => any;
  readonly resultofgetnativebalances_popitgame: (a: number) => any;
  readonly resultofgettokensbalances_tokens: (a: number) => any;
  readonly __wbg_resultofgettxhistory_free: (a: number, b: number) => void;
  readonly __wbg_txdata_free: (a: number, b: number) => void;
  readonly resultofgettxhistory_data: (a: number) => [number, number];
  readonly txdata_created_at: (a: number) => [number, number];
  readonly txdata_id: (a: number) => [number, number];
  readonly txdata_value: (a: number) => [number, number];
  readonly __wbg_wallet_free: (a: number, b: number) => void;
  readonly wallet_add_zkp_factor: (a: number, b: any) => any;
  readonly wallet_check_name_availability: (a: number, b: number, c: number) => any;
  readonly wallet_decrypt: (a: number, b: number, c: number, d: number, e: number) => [number, number, number, number];
  readonly wallet_deploy_miner: (a: number, b: any) => any;
  readonly wallet_deploy_wallet: (a: number, b: any) => any;
  readonly wallet_encrypt: (a: number, b: number, c: number, d: number, e: number) => [number, number, number];
  readonly wallet_gen_mining_keys: (a: number) => any;
  readonly wallet_get_keys_from_mnemonic: (a: number, b: number, c: number) => any;
  readonly wallet_get_miner_address: (a: number, b: any) => any;
  readonly wallet_get_miner_details_by_multifactor_address: (a: number, b: number, c: number) => any;
  readonly wallet_get_mining_history: (a: number, b: any) => any;
  readonly wallet_get_multifactor_balances: (a: number, b: any) => any;
  readonly wallet_get_multifactor_data_by_name: (a: number, b: number, c: number) => any;
  readonly wallet_get_tokens_balances: (a: number, b: any) => any;
  readonly wallet_hash: (a: number, b: number, c: number) => [number, number, number, number];
  readonly wallet_new: (a: number, b: number, c: number, d: number, e: number, f: number) => [number, number, number];
  readonly wallet_set_mining_keys: (a: number, b: any) => any;
  readonly wallet_sign: (a: number, b: any) => any;
  readonly wallet_validate_name: (a: number, b: number, c: number) => [number, number, number];
  readonly wallet_verify_mnemonic: (a: number, b: number, c: number) => any;
  readonly __wbg_resultofdeploymultifactor_free: (a: number, b: number) => void;
  readonly resultofdeploymultifactor_address: (a: number) => [number, number];
  readonly resultofdeploymultifactor_name: (a: number) => [number, number];
  readonly resultofdeploymultifactor_password_hash: (a: number) => [number, number];
  readonly resultofdeploymultifactor_phrase: (a: number) => [number, number];
  readonly resultofdeploymultifactor_pubkey: (a: number) => [number, number];
  readonly resultofdeploymultifactor_signing_keys: (a: number) => number;
  readonly __wbg_resultofgetminerdetails_free: (a: number, b: number) => void;
  readonly resultofgetminerdetails_address: (a: number) => [number, number];
  readonly resultofgetminerdetails_owner_address: (a: number) => [number, number];
  readonly resultofgetminerdetails_owner_public: (a: number) => any;
  readonly __wbg_miner_free: (a: number, b: number) => void;
  readonly miner_add_tap: (a: number, b: number, c: number) => [number, number];
  readonly miner_can_start: (a: number) => number;
  readonly miner_get_reward: (a: number) => any;
  readonly miner_new: (a: number, b: number, c: number, d: number, e: number, f: number, g: number, h: number, i: number, j: number) => any;
  readonly miner_remove_seed: (a: number, b: number, c: number) => void;
  readonly miner_start: (a: number, b: number, c: any) => [number, number];
  readonly miner_stop: (a: number) => void;
  readonly tc_create_context: (a: number) => number;
  readonly tc_destroy_string: (a: number) => void;
  readonly tc_read_string: (a: number, b: number) => void;
  readonly tc_request: (a: number, b: number, c: number, d: number, e: number) => void;
  readonly tc_request_ptr: (a: number, b: number, c: number, d: number, e: number) => void;
  readonly tc_request_sync: (a: number, b: number, c: number) => number;
  readonly tc_destroy_context: (a: number) => void;
  readonly rustsecp256k1_v0_8_1_context_create: (a: number) => number;
  readonly rustsecp256k1_v0_8_1_context_destroy: (a: number) => void;
  readonly rustsecp256k1_v0_8_1_default_error_callback_fn: (a: number, b: number) => void;
  readonly rustsecp256k1_v0_8_1_default_illegal_callback_fn: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke___web_sys_dd9ab144401e9f4___features__gen_Event__Event_____: (a: number, b: number, c: any) => void;
  readonly wasm_bindgen_238f863ef301c66f___closure__destroy___dyn_core_936d0f95abf73897___ops__function__Fn__web_sys_dd9ab144401e9f4___features__gen_Event__Event____Output_______: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke_______1_: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke______: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___closure__destroy___dyn_core_936d0f95abf73897___ops__function__FnMut_____Output_______: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke___web_sys_dd9ab144401e9f4___features__gen_IdbVersionChangeEvent__IdbVersionChangeEvent__core_936d0f95abf73897___result__Result_____wasm_bindgen_238f863ef301c66f___JsValue__: (a: number, b: number, c: any) => [number, number];
  readonly wasm_bindgen_238f863ef301c66f___closure__destroy___dyn_core_936d0f95abf73897___ops__function__FnMut__web_sys_dd9ab144401e9f4___features__gen_MessageEvent__MessageEvent____Output_______: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke___web_sys_dd9ab144401e9f4___features__gen_MessageEvent__MessageEvent_____: (a: number, b: number, c: any) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke_______2_: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___closure__destroy___dyn_core_936d0f95abf73897___ops__function__FnMut_____Output________1_: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke___wasm_bindgen_238f863ef301c66f___JsValue_____: (a: number, b: number, c: any) => void;
  readonly wasm_bindgen_238f863ef301c66f___closure__destroy___dyn_core_936d0f95abf73897___ops__function__FnMut__wasm_bindgen_238f863ef301c66f___JsValue____Output_______: (a: number, b: number) => void;
  readonly wasm_bindgen_238f863ef301c66f___convert__closures_____invoke___wasm_bindgen_238f863ef301c66f___JsValue__wasm_bindgen_238f863ef301c66f___JsValue_____: (a: number, b: number, c: any, d: any) => void;
  readonly __wbindgen_malloc: (a: number, b: number) => number;
  readonly __wbindgen_realloc: (a: number, b: number, c: number, d: number) => number;
  readonly __wbindgen_exn_store: (a: number) => void;
  readonly __externref_table_alloc: () => number;
  readonly __wbindgen_externrefs: WebAssembly.Table;
  readonly __wbindgen_free: (a: number, b: number, c: number) => void;
  readonly __externref_drop_slice: (a: number, b: number) => void;
  readonly __externref_table_dealloc: (a: number) => void;
  readonly __wbindgen_start: () => void;
}

export type SyncInitInput = BufferSource | WebAssembly.Module;

/**
* Instantiates the given `module`, which can either be bytes or
* a precompiled `WebAssembly.Module`.
*
* @param {{ module: SyncInitInput }} module - Passing `SyncInitInput` directly is deprecated.
*
* @returns {InitOutput}
*/
export function initSync(module: { module: SyncInitInput } | SyncInitInput): InitOutput;

/**
* If `module_or_path` is {RequestInfo} or {URL}, makes a request and
* for everything else, calls `WebAssembly.instantiate` directly.
*
* @param {{ module_or_path: InitInput | Promise<InitInput> }} module_or_path - Passing `InitInput` directly is deprecated.
*
* @returns {Promise<InitOutput>}
*/
export default function __wbg_init (module_or_path?: { module_or_path: InitInput | Promise<InitInput> } | InitInput | Promise<InitInput>): Promise<InitOutput>;
